# LearnPress Watermark REST API Documentation

Base URL: `/wp-json/mara7el-files/v1`

## Authentication
Most endpoints require a valid WordPress cookie (for logged-in users) or a valid capability check. The `/serve` endpoint uses a signed JWT-like token in the query string.

## LearnPress Integration
All file access is validated against LearnPress enrollment status. Users must be enrolled in the course or have the `lp_teacher` role to access protected files.

## Endpoints

### 1. Serve Protected File
Stream a watermarked file to the user (enrollment verified).

- **URL**: `/serve`
- **Method**: `GET`
- **Params**:
    - `token` (string, required): The signed access token.
- **Access Control**: 
    - Token must be valid and not expired
    - User must be enrolled in the associated LearnPress course
    - Teachers and administrators have automatic access
- **Response**: Binary file stream (PDF/Image) or JSON error.
- **Example**:
  ```
  GET /wp-json/mara7el-files/v1/serve?token=eyJ...
  ```

### 2. Create Token (Admin/Instructor)
Generate a signed token for a specific user and file (LearnPress teachers and admins only).

- **URL**: `/create-token`
- **Method**: `POST`
- **Headers**: `X-WP-Nonce: <nonce>`
- **Required Capabilities**: `manage_options` or `lp_teacher` role
- **Body**:
    - `user_id` (int, required): ID of the user to generate token for.
    - `file_id` (string, required): Filename of the protected file.
    - `course_id` (int, optional): LearnPress course ID for enrollment verification.
    - `ttl` (int, optional): Time to live in seconds (default: 3600).
- **Response**:
  ```json
  {
    "token": "eyJ...",
    "url": "https://site.com/wp-json/mara7el-files/v1/serve?token=eyJ...",
    "expires_in": 3600,
    "course_enrolled": true
  }
  ```

### 3. Get Access Logs (Admin)
Retrieve access logs (administrators only).

- **URL**: `/logs`
- **Method**: `GET`
- **Required Capability**: `manage_options`
- **Params**:
    - `user_id` (int, optional): Filter by user.
    - `file_id` (string, optional): Filter by file.
    - `course_id` (int, optional): Filter by LearnPress course.
    - `limit` (int, optional): Max results (default: 50).
- **Response**:
  ```json
  [
    {
      "id": "1",
      "user_id": "5",
      "file_id": "secret.pdf",
      "course_id": "123",
      "action": "download",
      "ip_address": "127.0.0.1",
      "created_at": "2023-10-27 10:00:00"
    }
  ]
  ```

## LearnPress Functions Used

The plugin integrates with these LearnPress functions:
- `learn_press_get_version()` - Check LearnPress version
- `learn_press_user_has_enrolled_course($course_id, $user_id)` - Verify enrollment
- `learn_press_get_course_by_item($item_id)` - Get course from lesson/quiz
