# Mara7el Live Classes for LearnPress

Integrate LearnPress courses and lessons with external live-session platforms (Zoom, Google Meet, Microsoft Teams).

## Description

Mara7el Live Classes is a **LearnPress addon** that allows instructors to schedule and manage live classes directly from the WordPress dashboard. Students enrolled in LearnPress courses can join live sessions seamlessly.

## Features

*   **LearnPress Integration**: Native integration with LearnPress courses and lessons
*   **API Integrations**: Connect with Zoom, Google Meet, and Microsoft Teams
*   **Enrollment-Based Access**: Only enrolled students can see and join live sessions
*   **Instructor Dashboard**: Adds a "Live Session" meta box to LearnPress Courses and Lessons
*   **Student Dashboard**: Automatically displays the "Join Class" button for enrolled students
*   **REST API**: Endpoints to create, list, and delete sessions programmatically
*   **Role-Based Permissions**: Supports LearnPress instructor and administrator roles

## Requirements

*   WordPress 5.8 or higher
*   PHP 7.4 or higher
*   **LearnPress 4.0 or higher** (Required)

## Installation

1.  Ensure **LearnPress** is installed and activated.
2.  Upload the `mara7el-live-classes` folder to the `/wp-content/plugins/` directory.
3.  Activate the plugin through the 'Plugins' menu in WordPress.
4.  The plugin will appear under **LearnPress > Live Classes** in the admin menu.

## Configuration

### Zoom Setup
1.  Go to **LearnPress > Live Classes**.
2.  Select the **Zoom** tab.
3.  Enter your Zoom Server-to-Server OAuth **API Key** and **API Secret**.
4.  Save settings.

### Google Meet Setup
1.  Go to **LearnPress > Live Classes**.
2.  Select the **Google Meet** tab.
3.  Enter your **Client ID** and **Client Secret** from Google Cloud Console.
4.  Save settings.

### Microsoft Teams Setup
1.  Go to **LearnPress > Live Classes**.
2.  Select the **Microsoft Teams** tab.
3.  Enter your **Client ID**, **Client Secret**, and **Tenant ID** from Azure Portal.
4.  Save settings.

## Usage

### Creating a Live Session

1.  Edit a LearnPress **Course** or **Lesson**.
2.  Scroll down to the **Live Session Settings** meta box.
3.  Select the **Platform** (Zoom, Meet, or Teams).
4.  Set the **Start Time** and **Duration**.
5.  Update/Publish the post.
6.  The plugin will automatically create the meeting and save the Join URL.

### Student Experience

1.  Students enrolled in the course will see a "Join Live Class" button on the course/lesson page.
2.  The button appears only for enrolled students (not visible to unenrolled visitors).
3.  Clicking the button opens the live session in the selected platform.

### Instructor/Admin Access

*   Administrators and LearnPress instructors can always see live session links.
*   They can manage live sessions for any course or lesson.

## Frequently Asked Questions

### Does this work with other LMS plugins?

No, this is a **LearnPress-exclusive addon**. It only works with LearnPress 4.0 or higher.

### Can students join without being enrolled?

No, the plugin checks LearnPress enrollment status. Only enrolled students can see and join live sessions.

### What happens if LearnPress is deactivated?

The plugin will display an error notice and stop functioning until LearnPress is reactivated.

## Support

For support, please visit the plugin documentation or contact support.

## Changelog

### 2.0.0
*   **Breaking Change**: Converted to LearnPress-exclusive addon
*   Removed support for other LMS plugins
*   Added LearnPress enrollment checks
*   Integrated with LearnPress menu structure
*   Added LearnPress instructor role support
*   Updated UI to match LearnPress design patterns

### 1.0.0
*   Initial release with multi-LMS support
