jQuery(document).ready(function($) {
    var modal = $('#mara7el-booking-modal');
    var btnGroup = $('#mara7el-book-group');
    var btnPrivate = $('#mara7el-book-private');
    var closeSpan = $('.mara7el-close');
    var bookingType = 'group'; // 'group' or 'private'
    var selectedSlot = null;

    // Open Modal
    btnGroup.on('click', function(e) {
        e.preventDefault();
        bookingType = 'group';
        openModal('Join a Group Class');
    });

    btnPrivate.on('click', function(e) {
        e.preventDefault();
        bookingType = 'private';
        openModal('Book a Private Class');
    });

    // Close Modal
    closeSpan.on('click', function() {
        modal.hide();
    });

    $(window).on('click', function(e) {
        if ($(e.target).is(modal)) {
            modal.hide();
        }
    });

    function openModal(title) {
        $('#mara7el-modal-title').text(title);
        modal.show();
        loadSlots();
    }

    function loadSlots() {
        // Mock API call to get slots
        // In real implementation, pass course_id and teacher_id
        var data = {
            course_id: 1, // Get from DOM
            teacher_id: 1 // Get from DOM or selection
        };

        $.ajax({
            url: mara7el_booking_vars.api_url + 'available-slots',
            method: 'GET',
            data: data,
            success: function(response) {
                var slotsHtml = '';
                if (response.slots && response.slots.length > 0) {
                    response.slots.forEach(function(slot) {
                        slotsHtml += '<div class="mara7el-slot" data-time="' + slot + '">' + slot + '</div>';
                    });
                } else {
                    slotsHtml = '<p>No slots available.</p>';
                }
                $('#mara7el-slots-container').html(slotsHtml);
            }
        });
    }

    // Slot Selection
    $(document).on('click', '.mara7el-slot', function() {
        $('.mara7el-slot').removeClass('selected');
        $(this).addClass('selected');
        selectedSlot = $(this).data('time');
    });

    // Confirm Booking
    $('#mara7el-confirm-booking').on('click', function() {
        if (!selectedSlot) {
            alert('Please select a time slot.');
            return;
        }

        var endpoint = bookingType === 'group' ? 'book-group' : 'book-private';
        
        $.ajax({
            url: mara7el_booking_vars.api_url + endpoint,
            method: 'POST',
            beforeSend: function ( xhr ) {
                xhr.setRequestHeader( 'X-WP-Nonce', mara7el_booking_vars.nonce );
            },
            data: {
                course_id: 1, // Get from DOM
                teacher_id: 1, // Get from DOM
                schedule_json: selectedSlot
            },
            success: function(response) {
                alert('Booking Successful!');
                modal.hide();
            },
            error: function(err) {
                alert('Booking Failed: ' + err.responseJSON.message);
            }
        });
    });
});
