<?php

class Mara7el_Booking_Admin_UI {

	/**
	 * LearnPress integration instance
	 */
	private $lp_integration;

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->lp_integration = Mara7el_Booking_LearnPress_Integration::get_instance();
	}

	/**
	 * Register admin menus under LearnPress.
	 */
	public function register_menus() {
		// Only add menus if LearnPress is active
		if ( ! $this->lp_integration->is_learnpress_active() ) {
			return;
		}

		// Add main menu under LearnPress
		add_submenu_page(
			'learn-press',
			__( 'Class Booking', 'mara7el-booking' ),
			__( 'Class Booking', 'mara7el-booking' ),
			'manage_options',
			'mara7el-booking',
			array( $this, 'render_dashboard' )
		);

		// Add Groups submenu
		add_submenu_page(
			'learn-press',
			__( 'Booking - Groups', 'mara7el-booking' ),
			__( '— Groups', 'mara7el-booking' ),
			'manage_options',
			'mara7el-booking-groups',
			array( $this, 'render_groups_page' )
		);

		// Add Private Classes submenu
		add_submenu_page(
			'learn-press',
			__( 'Booking - Private Classes', 'mara7el-booking' ),
			__( '— Private Classes', 'mara7el-booking' ),
			'manage_options',
			'mara7el-booking-private',
			array( $this, 'render_private_page' )
		);
	}

	/**
	 * Enqueue styles.
	 */
	public function enqueue_styles() {
		// Enqueue admin styles if needed
	}

	/**
	 * Enqueue scripts.
	 */
	public function enqueue_scripts() {
		// Enqueue admin scripts if needed
	}

	/**
	 * Render main dashboard.
	 */
	public function render_dashboard() {
		echo '<div class="wrap"><h1>Mara7el Booking Dashboard</h1><p>Welcome to the Class Booking System.</p></div>';
	}

	/**
	 * Render Groups management page.
	 */
	public function render_groups_page() {
		global $wpdb;
		$table = $wpdb->prefix . 'mara7el_groups';
		$groups = $wpdb->get_results( "SELECT * FROM $table ORDER BY created_at DESC" );

		echo '<div class="wrap">';
		echo '<h1>' . esc_html__( 'Manage Group Classes', 'mara7el-booking' ) . '</h1>';
		echo '<table class="wp-list-table widefat fixed striped">';
		echo '<thead><tr>';
		echo '<th>' . esc_html__( 'ID', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Course', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Instructor', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Schedule', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Status', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Members', 'mara7el-booking' ) . '</th>';
		echo '</tr></thead>';
		echo '<tbody>';
		
		if ( $groups ) {
			foreach ( $groups as $group ) {
				// Get member count
				$count = $wpdb->get_var( $wpdb->prepare( "SELECT count(*) FROM {$wpdb->prefix}mara7el_group_members WHERE group_id = %d", $group->id ) );
				
				// Get course title
				$course_title = $this->lp_integration->get_course_title( $group->course_id );
				
				// Get instructor name
				$instructor_name = $this->lp_integration->get_user_display_name( $group->teacher_id );
				
				echo '<tr>';
				echo '<td>' . esc_html( $group->id ) . '</td>';
				echo '<td><a href="' . esc_url( get_permalink( $group->course_id ) ) . '" target="_blank">' . esc_html( $course_title ) . '</a></td>';
				echo '<td>' . esc_html( $instructor_name ) . '</td>';
				echo '<td>' . esc_html( substr( $group->schedule_json, 0, 50 ) ) . '...</td>';
				echo '<td><span class="status-' . esc_attr( $group->status ) . '">' . esc_html( ucfirst( $group->status ) ) . '</span></td>';
				echo '<td>' . esc_html( $count ) . ' / 3</td>';
				echo '</tr>';
			}
		} else {
			echo '<tr><td colspan="6">' . esc_html__( 'No groups found.', 'mara7el-booking' ) . '</td></tr>';
		}
		
		echo '</tbody></table></div>';
	}

	/**
	 * Render Private Classes management page.
	 */
	public function render_private_page() {
		global $wpdb;
		$table = $wpdb->prefix . 'mara7el_private_classes';
		$classes = $wpdb->get_results( "SELECT * FROM $table ORDER BY created_at DESC" );

		echo '<div class="wrap">';
		echo '<h1>' . esc_html__( 'Manage Private Classes', 'mara7el-booking' ) . '</h1>';
		echo '<table class="wp-list-table widefat fixed striped">';
		echo '<thead><tr>';
		echo '<th>' . esc_html__( 'ID', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Student', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Instructor', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Course', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Schedule', 'mara7el-booking' ) . '</th>';
		echo '<th>' . esc_html__( 'Status', 'mara7el-booking' ) . '</th>';
		echo '</tr></thead>';
		echo '<tbody>';
		
		if ( $classes ) {
			foreach ( $classes as $class ) {
				// Get names from LearnPress
				$course_title = $this->lp_integration->get_course_title( $class->course_id );
				$student_name = $this->lp_integration->get_user_display_name( $class->student_id );
				$instructor_name = $this->lp_integration->get_user_display_name( $class->teacher_id );
				
				echo '<tr>';
				echo '<td>' . esc_html( $class->id ) . '</td>';
				echo '<td>' . esc_html( $student_name ) . '</td>';
				echo '<td>' . esc_html( $instructor_name ) . '</td>';
				echo '<td><a href="' . esc_url( get_permalink( $class->course_id ) ) . '" target="_blank">' . esc_html( $course_title ) . '</a></td>';
				echo '<td>' . esc_html( substr( $class->schedule_json, 0, 50 ) ) . '...</td>';
				echo '<td><span class="status-' . esc_attr( $class->status ) . '">' . esc_html( ucfirst( $class->status ) ) . '</span></td>';
				echo '</tr>';
			}
		} else {
			echo '<tr><td colspan="6">' . esc_html__( 'No private classes found.', 'mara7el-booking' ) . '</td></tr>';
		}
		
		echo '</tbody></table></div>';
	}
}
