<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Mara7el_Watermark_File_Protection
 * Handles storage and protection of original files.
 */
class Mara7el_Watermark_File_Protection {

	/**
	 * Protected directory path.
	 *
	 * @var string
	 */
	private static $protected_dir;

	/**
	 * Constructor.
	 */
	public function __construct() {
		self::$protected_dir = MARA7EL_PROTECTED_DIR;
	}

	/**
	 * Create the protected directory and .htaccess.
	 */
	public static function create_protection_dir() {
		$dir = MARA7EL_PROTECTED_DIR;
		
		if ( ! file_exists( $dir ) ) {
			wp_mkdir_p( $dir );
		}

		// Create .htaccess to deny all access
		$htaccess = $dir . '/.htaccess';
		if ( ! file_exists( $htaccess ) ) {
			file_put_contents( $htaccess, "Order Deny,Allow\nDeny from all" );
		}

		// Create index.php to prevent listing
		$index = $dir . '/index.php';
		if ( ! file_exists( $index ) ) {
			file_put_contents( $index, '<?php // Silence is golden' );
		}
	}

	/**
	 * Get the path to a protected file.
	 *
	 * @param string $filename Filename.
	 * @return string|false Absolute path or false if not found.
	 */
	public function get_file_path( $filename ) {
		$path = self::$protected_dir . '/' . $filename;
		if ( file_exists( $path ) ) {
			return $path;
		}
		return false;
	}

	/**
	 * Move an uploaded file to the protected directory.
	 *
	 * @param string $source_path Source file path.
	 * @param string $filename    Target filename.
	 * @return string|false New path or false.
	 */
	public function protect_file( $source_path, $filename ) {
		$target_path = self::$protected_dir . '/' . $filename;
		if ( rename( $source_path, $target_path ) ) {
			return $target_path;
		}
		return false;
	}
}
