<?php

class Mara7el_Booking_Group_Manager {

	/**
	 * Create a new group.
	 *
	 * @param int $course_id
	 * @param int $teacher_id
	 * @param string $schedule_json
	 * @return int|false Group ID or false
	 */
	public function create_group( $course_id, $teacher_id, $schedule_json ) {
		global $wpdb;
		$table = $wpdb->prefix . 'mara7el_groups';

		$result = $wpdb->insert(
			$table,
			array(
				'course_id'     => $course_id,
				'teacher_id'    => $teacher_id,
				'schedule_json' => $schedule_json,
				'status'        => 'active',
				'created_at'    => current_time( 'mysql' ),
			),
			array( '%d', '%d', '%s', '%s', '%s' )
		);

		if ( $result ) {
			return $wpdb->insert_id;
		}
		return false;
	}

	/**
	 * Add a student to a group.
	 *
	 * @param int $group_id
	 * @param int $student_id
	 * @return bool
	 */
	public function add_student_to_group( $group_id, $student_id ) {
		global $wpdb;
		
		// Check capacity
		if ( $this->get_group_member_count( $group_id ) >= 3 ) {
			return false; // Full
		}

		$table = $wpdb->prefix . 'mara7el_group_members';
		$result = $wpdb->insert(
			$table,
			array(
				'group_id'   => $group_id,
				'student_id' => $student_id,
				'joined_at'  => current_time( 'mysql' ),
			),
			array( '%d', '%d', '%s' )
		);

		return (bool) $result;
	}

	/**
	 * Get number of students in a group.
	 *
	 * @param int $group_id
	 * @return int
	 */
	public function get_group_member_count( $group_id ) {
		global $wpdb;
		$table = $wpdb->prefix . 'mara7el_group_members';
		return (int) $wpdb->get_var( $wpdb->prepare( "SELECT count(*) FROM $table WHERE group_id = %d", $group_id ) );
	}

	/**
	 * Find an available group for a course and schedule.
	 *
	 * @param int $course_id
	 * @param string $schedule_json (Simplified matching for now)
	 * @return int|false Group ID or false
	 */
	public function find_available_group( $course_id, $schedule_json ) {
		global $wpdb;
		$table_groups = $wpdb->prefix . 'mara7el_groups';
		
		// Find active groups for this course with matching schedule
		// Note: JSON matching in SQL is tricky. For MVP, we assume exact string match or handle in PHP.
		// Ideally, we'd normalize schedule IDs or use a separate table for schedules.
		
		$groups = $wpdb->get_results( $wpdb->prepare( 
			"SELECT id FROM $table_groups WHERE course_id = %d AND status = 'active' AND schedule_json = %s", 
			$course_id, 
			$schedule_json 
		) );

		foreach ( $groups as $group ) {
			if ( $this->get_group_member_count( $group->id ) < 3 ) {
				return $group->id;
			}
		}

		return false;
	}
}
