<?php

class Mara7el_Booking_Notifications {

	public function __construct() {
		// Hook into booking actions
		// Note: These actions should be fired from the Manager classes. 
		// For MVP, we'll assume we add do_action() calls there later or hook into DB inserts if possible.
		// Better approach: Add custom actions in Manager classes.
		
		add_action( 'mara7el_group_booked', array( $this, 'notify_group_booking' ), 10, 2 );
		add_action( 'mara7el_private_booked', array( $this, 'notify_private_booking' ), 10, 2 );
	}

	/**
	 * Notify on group booking.
	 *
	 * @param int $group_id
	 * @param int $student_id
	 */
	public function notify_group_booking( $group_id, $student_id ) {
		$student_email = $this->get_user_email( $student_id );
		$subject = 'Group Class Confirmation';
		$message = "You have successfully joined Group #$group_id.";
		
		wp_mail( $student_email, $subject, $message );
	}

	/**
	 * Notify on private booking.
	 *
	 * @param int $booking_id
	 * @param int $student_id
	 */
	public function notify_private_booking( $booking_id, $student_id ) {
		$student_email = $this->get_user_email( $student_id );
		$subject = 'Private Class Confirmation';
		$message = "You have successfully booked Private Class #$booking_id.";
		
		wp_mail( $student_email, $subject, $message );
	}

	private function get_user_email( $user_id ) {
		$user_info = get_userdata( $user_id );
		return $user_info ? $user_info->user_email : '';
	}
}

new Mara7el_Booking_Notifications();
