<?php

class Mara7el_Booking_Private_Manager {

	/**
	 * Create a private class booking.
	 *
	 * @param int $student_id
	 * @param int $teacher_id
	 * @param int $course_id
	 * @param string $schedule_json
	 * @return int|false Private Class ID or false
	 */
	public function create_private_class( $student_id, $teacher_id, $course_id, $schedule_json ) {
		global $wpdb;
		$table = $wpdb->prefix . 'mara7el_private_classes';

		$result = $wpdb->insert(
			$table,
			array(
				'student_id'    => $student_id,
				'teacher_id'    => $teacher_id,
				'course_id'     => $course_id,
				'schedule_json' => $schedule_json,
				'status'        => 'active',
				'created_at'    => current_time( 'mysql' ),
			),
			array( '%d', '%d', '%d', '%s', '%s', '%s' )
		);

		if ( $result ) {
			return $wpdb->insert_id;
		}
		return false;
	}

	/**
	 * Get private classes for a student.
	 *
	 * @param int $student_id
	 * @return array
	 */
	public function get_student_private_classes( $student_id ) {
		global $wpdb;
		$table = $wpdb->prefix . 'mara7el_private_classes';
		return $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table WHERE student_id = %d", $student_id ) );
	}
}
