<?php
/**
 * Session Manager Class.
 *
 * @package Mara7el_Live
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Mara7el_Live_Session_Manager {

	/**
	 * Create a session for a post.
	 *
	 * @param int $post_id Post ID.
	 */
	public function create_session( $post_id ) {
		$platform   = get_post_meta( $post_id, '_mara7el_live_platform', true );
		$start_time = get_post_meta( $post_id, '_mara7el_live_start_time', true );
		$duration   = get_post_meta( $post_id, '_mara7el_live_duration', true );
		$title      = get_the_title( $post_id );

		if ( ! $platform || ! $start_time ) {
			return;
		}

		$data = array(
			'topic'      => $title,
			'start_time' => $start_time,
			'duration'   => $duration,
			'timezone'   => get_option( 'timezone_string' ) ?: 'UTC',
		);

		$response = false;

		switch ( $platform ) {
			case 'zoom':
				$api      = new Mara7el_Live_Zoom_API();
				$response = $api->create_meeting( $data );
				break;
			case 'google_meet':
				$api      = new Mara7el_Live_Google_Meet_API();
				$response = $api->create_meeting( $data );
				break;
			case 'teams':
				$api      = new Mara7el_Live_Teams_API();
				$response = $api->create_meeting( $data );
				break;
		}

		if ( $response && ! is_wp_error( $response ) ) {
			update_post_meta( $post_id, '_mara7el_live_session_id', $response['id'] );
			update_post_meta( $post_id, '_mara7el_live_join_url', $response['join_url'] );
			update_post_meta( $post_id, '_mara7el_live_start_url', $response['start_url'] );
		}
	}

	/**
	 * Sync all active sessions.
	 * This would typically query the API to check if meetings are still valid or have ended.
	 */
	public function sync_all_sessions() {
		$args = array(
			'post_type'  => array( 'lp_course', 'lp_lesson' ),
			'meta_query' => array(
				array(
					'key'     => '_mara7el_live_session_id',
					'compare' => 'EXISTS',
				),
			),
			'posts_per_page' => 50, // Batch size
		);

		$query = new WP_Query( $args );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$post_id = get_the_ID();
				// Logic to check status with API would go here.
				// For example:
				// $platform = get_post_meta( $post_id, '_mara7el_live_platform', true );
				// $api = ... get api instance ...
				// $status = $api->get_meeting_status( ... );
				// update_post_meta( $post_id, '_mara7el_live_status', $status );
			}
			wp_reset_postdata();
		}
	}
}
