# LearnPress Watermark & Protection - User Guide

## Overview
This plugin securely watermarks and tracks access to protected files within LearnPress courses. It ensures that only enrolled students and course teachers can access course materials.

## Getting Started

1. **Prerequisites**: Make sure LearnPress 4.3.1+ is installed and active.
2. **Configure Settings**: Go to **LearnPress > Watermark** in your WordPress admin.
3. **Enable Watermarking**: Check the "Enable Watermarking" option.
4. **Customize Watermark Text**: Use placeholders like `{user_email}`, `{user_id}`, `{date}`, `{ip_address}`.

## Using Protected Files in LearnPress Courses

### In Course Lessons
1. Edit any LearnPress lesson or course content
2. Add the shortcode: `[mara7el_protected_file file="document.pdf" text="Download PDF"]`
3. The file will only be accessible to:
   - Students enrolled in the course
   - Teachers assigned to the course
   - Administrators

### Access Control
- **Enrollment Check**: Students must be enrolled in the course to access files
- **Teacher Access**: Users with the `lp_teacher` role have automatic access
- **Guest Users**: Will see a login prompt
- **Unenrolled Users**: Will see an enrollment required message

## Watermark Placeholders
- `{user_name}` - User's display name
- `{user_email}` - User's email address
- `{user_id}` - User ID number
- `{date}` - Current date
- `{ip_address}` - User's IP address

## Troubleshooting

- **PDFs not watermarked?** Ensure `FPDF` and `FPDI` are installed via Composer.
- **Images not watermarked?** Ensure GD Library is enabled in PHP.
- **Access Denied?** Check if user is enrolled in the course or has teacher role.
- **Plugin won't activate?** Ensure LearnPress 4.3.1+ is installed and activated first.

## Viewing Access Logs
Access logs are stored in the database and track every file view with user details, timestamp, and IP address for security auditing.
