<?php

/**
 * Fired during plugin activation.
 */
class Mara7el_Booking_Activator {

	/**
	 * Create the necessary database tables.
	 */
	public static function activate() {
		// Check if LearnPress is active
		if ( ! class_exists( 'LearnPress' ) ) {
			deactivate_plugins( plugin_basename( dirname( __FILE__ ) . '/../mara7el-booking.php' ) );
			wp_die(
				wp_kses_post( __( '<strong>Mara7el Booking - LearnPress Addon</strong> requires LearnPress to be installed and activated. <br><a href="' . admin_url( 'plugins.php' ) . '">Return to Plugins</a>', 'mara7el-booking' ) ),
				esc_html__( 'Plugin Activation Error', 'mara7el-booking' ),
				array( 'back_link' => true )
			);
		}
		
		global $wpdb;

		$charset_collate = $wpdb->get_charset_collate();

		// Table: Groups
		$table_groups = $wpdb->prefix . 'mara7el_groups';
		$sql_groups = "CREATE TABLE $table_groups (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			course_id bigint(20) NOT NULL,
			teacher_id bigint(20) NOT NULL,
			schedule_json longtext NOT NULL,
			status varchar(20) DEFAULT 'active' NOT NULL,
			created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			PRIMARY KEY  (id),
			KEY course_id (course_id),
			KEY teacher_id (teacher_id)
		) $charset_collate;";

		// Table: Group Members
		$table_group_members = $wpdb->prefix . 'mara7el_group_members';
		$sql_group_members = "CREATE TABLE $table_group_members (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			group_id mediumint(9) NOT NULL,
			student_id bigint(20) NOT NULL,
			joined_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			PRIMARY KEY  (id),
			KEY group_id (group_id),
			KEY student_id (student_id)
		) $charset_collate;";

		// Table: Private Classes
		$table_private = $wpdb->prefix . 'mara7el_private_classes';
		$sql_private = "CREATE TABLE $table_private (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			student_id bigint(20) NOT NULL,
			teacher_id bigint(20) NOT NULL,
			course_id bigint(20) NOT NULL,
			schedule_json longtext NOT NULL,
			status varchar(20) DEFAULT 'active' NOT NULL,
			created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			PRIMARY KEY  (id),
			KEY student_id (student_id),
			KEY teacher_id (teacher_id)
		) $charset_collate;";

		// Table: Sessions
		$table_sessions = $wpdb->prefix . 'mara7el_sessions';
		$sql_sessions = "CREATE TABLE $table_sessions (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			type varchar(20) NOT NULL, -- 'group' or 'private'
			reference_id mediumint(9) NOT NULL, -- group_id or private_class_id
			session_date datetime NOT NULL,
			session_link varchar(255) DEFAULT '' NOT NULL,
			attendance_json longtext DEFAULT '' NOT NULL,
			status varchar(20) DEFAULT 'scheduled' NOT NULL,
			PRIMARY KEY  (id),
			KEY reference_id (reference_id),
			KEY session_date (session_date)
		) $charset_collate;";

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql_groups );
		dbDelta( $sql_group_members );
		dbDelta( $sql_private );
		dbDelta( $sql_sessions );
	}
}
