<?php
/**
 * LearnPress Addon Registration Class.
 *
 * @package Mara7el_Live
 * @since   2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Mara7el_Live_LearnPress_Addon
 *
 * Handles registration of the plugin as a LearnPress addon.
 */
class Mara7el_Live_LearnPress_Addon {

	/**
	 * Constructor.
	 */
	public function __construct() {
		// Register addon using multiple methods for better compatibility
		add_filter( 'learn-press/addon-info', array( $this, 'register_addon_info' ) );
		add_filter( 'learn_press_addon_info', array( $this, 'register_addon_info' ) );
		
		// Try direct registration if function exists
		if ( function_exists( 'learn_press_register_addon' ) ) {
			learn_press_register_addon( 'mara7el-live-classes', $this->get_addon_data() );
		}
	}

	/**
	 * Get addon data array.
	 *
	 * @since 2.0.0
	 * @return array Addon data.
	 */
	private function get_addon_data() {
		return array(
			'name'        => __( 'Mara7el Live Classes', 'mara7el-live' ),
			'description' => __( 'Integrates LearnPress courses and lessons with live-session platforms (Zoom, Google Meet, Microsoft Teams).', 'mara7el-live' ),
			'version'     => MARA7EL_LIVE_VERSION,
			'author'      => 'Mara7el',
			'plugin_url'  => 'https://example.com/mara7el-live-classes',
			'plugin_file' => MARA7EL_LIVE_PATH . 'mara7el-live-classes.php',
		);
	}

	/**
	 * Register addon information with LearnPress.
	 *
	 * @since 2.0.0
	 * @param array $addons Existing addons.
	 * @return array Modified addons array.
	 */
	public function register_addon_info( $addons ) {
		if ( ! is_array( $addons ) ) {
			$addons = array();
		}
		
		$addons['mara7el-live-classes'] = $this->get_addon_data();

		return $addons;
	}

	/**
	 * Get addon settings URL.
	 *
	 * @since 2.0.0
	 * @return string Settings page URL.
	 */
	public static function get_settings_url() {
		return admin_url( 'admin.php?page=mara7el-live-settings' );
	}

	/**
	 * Get addon information.
	 *
	 * @since 2.0.0
	 * @return array Addon information.
	 */
	public static function get_addon_info() {
		return array(
			'name'              => __( 'Mara7el Live Classes', 'mara7el-live' ),
			'description'       => __( 'Add live session capabilities to your LearnPress courses and lessons.', 'mara7el-live' ),
			'version'           => MARA7EL_LIVE_VERSION,
			'requires_php'      => '7.4',
			'requires_wp'       => '5.8',
			'requires_lp'       => MARA7EL_LIVE_LEARNPRESS_MIN_VERSION,
			'supported_platforms' => array( 'Zoom', 'Google Meet', 'Microsoft Teams' ),
		);
	}
}
