<?php
/**
 * Main Loader Class.
 *
 * @package Mara7el_Live
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Mara7el_Live_Loader {

	/**
	 * The single instance of the class.
	 *
	 * @var Mara7el_Live_Loader
	 * @since 1.0.0
	 */
	protected static $_instance = null;

	/**
	 * Main Mara7el_Live_Loader Instance.
	 *
	 * Ensures only one instance of Mara7el_Live_Loader is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @return Mara7el_Live_Loader - Main instance.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->includes();
		$this->init_hooks();
	}

	/**
	 * Include required core files used in admin and on the frontend.
	 */
	public function includes() {
		require_once MARA7EL_LIVE_PATH . 'includes/class-learnpress-addon.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-admin-settings.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-zoom-api.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-google-meet-api.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-teams-api.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-session-manager.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-lms-hooks.php';
		require_once MARA7EL_LIVE_PATH . 'includes/class-rest-api.php';
	}

	/**
	 * Hook into actions and filters.
	 */
	private function init_hooks() {
		// Initialize LearnPress addon registration
		new Mara7el_Live_LearnPress_Addon();
		
		// Initialize classes
		new Mara7el_Live_Admin_Settings();
		new Mara7el_Live_LMS_Hooks();
		new Mara7el_Live_REST_API();
		
		// Schedule cron jobs
		add_action( 'init', array( $this, 'schedule_cron' ) );
		add_action( 'mara7el_live_sync_event', array( $this, 'run_sync_job' ) );
	}

	/**
	 * Schedule Cron Job.
	 */
	public function schedule_cron() {
		if ( ! wp_next_scheduled( 'mara7el_live_sync_event' ) ) {
			wp_schedule_event( time(), 'hourly', 'mara7el_live_sync_event' );
		}
	}

	/**
	 * Run Sync Job.
	 */
	public function run_sync_job() {
		$manager = new Mara7el_Live_Session_Manager();
		$manager->sync_all_sessions();
	}
}
