<?php

class Mara7el_Booking_Student_UI {

	/**
	 * LearnPress integration instance
	 */
	private $lp_integration;

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->lp_integration = Mara7el_Booking_LearnPress_Integration::get_instance();
	}

	/**
	 * Render student dashboard.
	 */
	public function render_dashboard() {
		if ( ! is_user_logged_in() ) {
			return '<p>' . esc_html__( 'Please login to view your bookings.', 'mara7el-booking' ) . '</p>';
		}

		$student_id = get_current_user_id();
		global $wpdb;

		// Get student's group memberships
		$group_memberships = $wpdb->get_results( $wpdb->prepare(
			"SELECT gm.*, g.course_id, g.teacher_id, g.schedule_json, g.status 
			FROM {$wpdb->prefix}mara7el_group_members gm 
			JOIN {$wpdb->prefix}mara7el_groups g ON gm.group_id = g.id 
			WHERE gm.student_id = %d 
			ORDER BY gm.joined_at DESC",
			$student_id
		) );

		// Get student's private classes
		$private_classes = $wpdb->get_results( $wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}mara7el_private_classes WHERE student_id = %d ORDER BY created_at DESC",
			$student_id
		) );

		ob_start();
		?>
		<div class="mara7el-student-dashboard">
			<h2><?php esc_html_e( 'My Booked Classes', 'mara7el-booking' ); ?></h2>

			<h3><?php esc_html_e( 'Group Classes', 'mara7el-booking' ); ?></h3>
			<?php if ( $group_memberships ) : ?>
				<table class="mara7el-table">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Course', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Instructor', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Status', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Joined', 'mara7el-booking' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $group_memberships as $membership ) : 
							$course_title = $this->lp_integration->get_course_title( $membership->course_id );
							$instructor_name = $this->lp_integration->get_user_display_name( $membership->teacher_id );
						?>
						<tr>
							<td><a href="<?php echo esc_url( get_permalink( $membership->course_id ) ); ?>"><?php echo esc_html( $course_title ); ?></a></td>
							<td><?php echo esc_html( $instructor_name ); ?></td>
							<td><?php echo esc_html( ucfirst( $membership->status ) ); ?></td>
							<td><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $membership->joined_at ) ) ); ?></td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			<?php else : ?>
				<p><?php esc_html_e( 'You have not joined any group classes yet.', 'mara7el-booking' ); ?></p>
			<?php endif; ?>

			<h3><?php esc_html_e( 'Private Classes', 'mara7el-booking' ); ?></h3>
			<?php if ( $private_classes ) : ?>
				<table class="mara7el-table">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Course', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Instructor', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Status', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Booked', 'mara7el-booking' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $private_classes as $class ) : 
							$course_title = $this->lp_integration->get_course_title( $class->course_id );
							$instructor_name = $this->lp_integration->get_user_display_name( $class->teacher_id );
						?>
						<tr>
							<td><a href="<?php echo esc_url( get_permalink( $class->course_id ) ); ?>"><?php echo esc_html( $course_title ); ?></a></td>
							<td><?php echo esc_html( $instructor_name ); ?></td>
							<td><?php echo esc_html( ucfirst( $class->status ) ); ?></td>
							<td><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $class->created_at ) ) ); ?></td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			<?php else : ?>
				<p><?php esc_html_e( 'You have not booked any private classes yet.', 'mara7el-booking' ); ?></p>
			<?php endif; ?>
		</div>
		<?php
		return ob_get_clean();
	}
}
