<?php

class Mara7el_Booking_Teacher_UI {

	/**
	 * LearnPress integration instance
	 */
	private $lp_integration;

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->lp_integration = Mara7el_Booking_LearnPress_Integration::get_instance();
	}

	/**
	 * Render the teacher dashboard.
	 */
	public function render_dashboard() {
		if ( ! is_user_logged_in() ) {
			return '<p>' . esc_html__( 'Please login to view your dashboard.', 'mara7el-booking' ) . '</p>';
		}

		$teacher_id = get_current_user_id();

		// Check if user is an instructor
		if ( ! $this->lp_integration->is_instructor( $teacher_id ) ) {
			return '<p>' . esc_html__( 'This dashboard is only available for instructors.', 'mara7el-booking' ) . '</p>';
		}

		global $wpdb;
		
		// Get teacher's groups
		$groups = $wpdb->get_results( $wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}mara7el_groups WHERE teacher_id = %d ORDER BY created_at DESC",
			$teacher_id
		) );

		// Get teacher's private classes
		$private_classes = $wpdb->get_results( $wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}mara7el_private_classes WHERE teacher_id = %d ORDER BY created_at DESC",
			$teacher_id
		) );

		ob_start();
		?>
		<div class="mara7el-teacher-dashboard">
			<h2><?php esc_html_e( 'Your Assigned Classes', 'mara7el-booking' ); ?></h2>
			
			<h3><?php esc_html_e( 'Group Classes', 'mara7el-booking' ); ?></h3>
			<?php if ( $groups ) : ?>
				<table class="mara7el-table">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Course', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Members', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Status', 'mara7el-booking' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $groups as $group ) : 
							$count = $wpdb->get_var( $wpdb->prepare( "SELECT count(*) FROM {$wpdb->prefix}mara7el_group_members WHERE group_id = %d", $group->id ) );
							$course_title = $this->lp_integration->get_course_title( $group->course_id );
						?>
						<tr>
							<td><a href="<?php echo esc_url( get_permalink( $group->course_id ) ); ?>"><?php echo esc_html( $course_title ); ?></a></td>
							<td><?php echo esc_html( $count ); ?> / 3</td>
							<td><?php echo esc_html( ucfirst( $group->status ) ); ?></td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			<?php else : ?>
				<p><?php esc_html_e( 'No group classes assigned yet.', 'mara7el-booking' ); ?></p>
			<?php endif; ?>

			<h3><?php esc_html_e( 'Private Classes', 'mara7el-booking' ); ?></h3>
			<?php if ( $private_classes ) : ?>
				<table class="mara7el-table">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Student', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Course', 'mara7el-booking' ); ?></th>
							<th><?php esc_html_e( 'Status', 'mara7el-booking' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $private_classes as $class ) : 
							$student_name = $this->lp_integration->get_user_display_name( $class->student_id );
							$course_title = $this->lp_integration->get_course_title( $class->course_id );
						?>
						<tr>
							<td><?php echo esc_html( $student_name ); ?></td>
							<td><a href="<?php echo esc_url( get_permalink( $class->course_id ) ); ?>"><?php echo esc_html( $course_title ); ?></a></td>
							<td><?php echo esc_html( ucfirst( $class->status ) ); ?></td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			<?php else : ?>
				<p><?php esc_html_e( 'No private classes assigned yet.', 'mara7el-booking' ); ?></p>
			<?php endif; ?>
		</div>
		<?php
		return ob_get_clean();
	}
}
