<?php
use LearnPress\Upsell\Package\Package;

class LP_Wc_Add_Package_Ajax {

	protected static $_instance = null;
	// protected $currencies       = array();

	public $namespace = 'learpress-woo-payment/v1';

	/**
	 * Constructor
	 */
	protected $_hook_arr = array( 'lp_wc_add_package_to_cart' );

	protected function __construct() {
		foreach ( $this->_hook_arr as $hook ) {
			add_action( 'wp_ajax_' . $hook, array( $this, $hook ) );
			add_action( 'wp_ajax_nopriv_' . $hook, array( $this, $hook ) );
		}
	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function lp_wc_add_package_to_cart() {
		$response = new LP_REST_Response();
		try {
			$post_data      = LP_Helper::sanitize_params_submitted( $_POST );
			$response->data = $post_data;
			if ( empty( $post_data['nonce'] ) || ! wp_verify_nonce( $post_data['nonce'], 'lp-woo-payment-nonce' ) ) {
				throw new Exception( esc_html__( 'Require nonce.', 'learnpress-woo-payment' ) );
			}
			if ( empty( $post_data['package_id'] ) ) {
				throw new Exception( esc_html__( 'Empty package id', 'learnpress-woo-payment' ) );
			}
			$package_id = (int) $post_data['package_id'];
			$package    = new Package( $package_id );
			if ( ! $package ) {
				throw new Exception( esc_html__( 'Package is not exist.', 'learnpress-woo-payment' ) );
			}
			$wc_cart       = WC()->cart;
			$cart_item_key = $wc_cart->add_to_cart( $package_id );
			if ( $cart_item_key ) {
				$response->message = $cart_item_key;
				$course            = true;
				$data              = array();
				ob_start();
				// Set content button view cart
				LP_Addon_Woo_Payment_Preload::$addon->get_template( 'view-cart', compact( 'course' ) );
				$view_cart_content        = ob_get_contents();
				$data['button_view_cart'] = $view_cart_content;
				// Set content mini cart
				woocommerce_mini_cart();
				$mini_cart = ob_get_contents();
				ob_clean();
				ob_end_flush();

				$data['widget_shopping_cart_content'] = $mini_cart;
				$data['count_items']                  = WC()->cart->get_cart_contents_count();

				if ( 'yes' == LP_Settings::get_option( 'woo-payment_redirect_to_checkout', 'no' ) ) {
					$data['redirect_to'] = wc_get_checkout_url();
				}
				$response->data   = $data;
				$response->status = 'success';
			} else {
				$wc_notices = wc_get_notices();

				if ( isset( $wc_notices['error'] ) && ! empty( $wc_notices['error'] ) ) {
					throw new Exception( esc_html__( 'Package is only added once.', 'learnpress-woo-payment' ) );
				}
			}
		} catch ( Throwable $e ) {
			$response->status  = 'error';
			$response->message = $e->getMessage();
		}
		wp_send_json( $response );
	}
}

LP_Wc_Add_Package_Ajax::instance();
